DROP PROCEDURE [hips].[RemoveAuditInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date:   6 May 2013
-- Description:   Inserts a new record into the Remove Audit Table
-- =============================================
CREATE PROCEDURE [hips].[RemoveAuditInsert] 
(
	  @ClinicalDocumentId INT
	, @RemovalReasonId INT
	, @AuditInformation VARBINARY(MAX) = NULL
	, @UserModified varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @RemoveAuditId int

    SET @intErrorCode = 0


	INSERT INTO hips.RemoveAudit
	(
		[ClinicalDocumentId],
		[RemovalReasonId],
		[AuditInformation],
		[DateCreated],
        [UserCreated],
        [DateModified],
        [UserModified]
		)
VALUES
	(
	  @ClinicalDocumentId
	, @RemovalReasonId
	, @AuditInformation
	, GETDATE()
    , @UserModified
    , GETDATE()
    , @UserModified
	)
	
	 SELECT @intErrorCode = @@ERROR , @RemoveAuditId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [RemoveAuditId],
                ClinicalDocumentId,
                ra.RemovalReasonId,
				rr.Description AS RemovalReasonDescription,
				AuditInformation,
                ra.[DateCreated],
                ra.[UserCreated],
                ra.[DateModified],
                ra.[UserModified]
         FROM [hips].[RemoveAudit] ra
		 INNER JOIN [hips].[RemovalReason] rr ON ra.RemovalReasonId = rr.RemovalReasonId
         WHERE [RemoveAuditId] = @RemoveAuditId
    END

    RETURN(@intErrorCode)

END

GO

